<?php
// Inicia a sessão para acessar os dados do usuário.
session_start();

// Verifica se o usuário está logado e se o perfil é de professor.
if (!isset($_SESSION['usuario']) || strtoupper($_SESSION['usuario']['perfil']) !== 'PROFESSOR') {
    header("Location: login.php");
    exit;
}

// Inclui o arquivo de conexão com o banco de dados.
include 'conexao.php';
// Inclui o arquivo que verifica o login, se necessário.
include 'verifica_login.php';

// Obtém os dados do usuário da sessão.
$usuario = $_SESSION['usuario'];
$nome_usuario = $usuario['nome'] ?? 'Professor';

// Simulação de dados de cátedras
$catedras = [
    ['nome' => 'Cátedra de Matemática', 'descricao' => 'Material didático para aulas de matemática.'],
    ['nome' => 'Cátedra de Ciências', 'descricao' => 'Recursos para o ensino de biologia, química e física.'],
];
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ver Cátedras - SISMAG</title>
    <link rel="stylesheet" href="https://rsms.me/inter/inter.css">
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-8">

<div class="max-w-4xl mx-auto bg-white p-6 rounded-xl shadow-md">
    <h1 class="text-2xl font-bold text-gray-800 mb-6">Cátedras</h1>
    <p class="text-gray-600 mb-4">Olá, professor(a) <?= htmlspecialchars($nome_usuario) ?>. Aqui você pode ver os materiais de cátedra disponíveis.</p>

    <ul class="space-y-4">
        <?php foreach ($catedras as $catedra): ?>
            <li class="bg-gray-50 p-4 rounded-lg shadow-sm border border-gray-200">
                <h3 class="text-lg font-semibold text-gray-800"><?= htmlspecialchars($catedra['nome']) ?></h3>
                <p class="text-gray-600 mt-1"><?= htmlspecialchars($catedra['descricao']) ?></p>
                <a href="#" class="mt-2 inline-block text-blue-600 hover:text-blue-800 font-medium">Ver detalhes</a>
            </li>
        <?php endforeach; ?>
    </ul>
</div>

</body>
</html>



